"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bemChatRoutes = void 0;
const hono_1 = require("hono");
const bemchat_controller_1 = require("./bemchat.controller");
const bemChatRoutes = new hono_1.Hono();
exports.bemChatRoutes = bemChatRoutes;
bemChatRoutes.post("/create", bemchat_controller_1.bemchatController.createOne);
bemChatRoutes.get("/status/:jobId", bemchat_controller_1.bemchatController.getStatus);
bemChatRoutes.post("/restart", bemchat_controller_1.bemchatController.restartInstance);
bemChatRoutes.delete("/delete/:name", bemchat_controller_1.bemchatController.deleteOne);
bemChatRoutes.post("/update", bemchat_controller_1.bemchatController.updateOne);
bemChatRoutes.post("/update-all", bemchat_controller_1.bemchatController.updateAll);
bemChatRoutes.post("/update-database/:name", bemchat_controller_1.bemchatController.updateDatabase);
bemChatRoutes.get("/list", bemchat_controller_1.bemchatController.list);
//# sourceMappingURL=bemchat.routes.js.map