"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateNginxConfigContent = generateNginxConfigContent;
exports.createNginxConfig = createNginxConfig;
exports.removeNginxConfig = removeNginxConfig;
const node_path_1 = __importDefault(require("node:path"));
const fileSystem = __importStar(require("./fileSystem"));
/**
 * Gera o conteúdo de uma configuração Nginx para uma instância API
 * @param instanceName - Nome da instância
 * @param port - Porta onde a instância está rodando
 * @returns Conteúdo da configuração Nginx
 */
function generateNginxConfigContent(instanceName, port) {
    return `server {
    server_name ${instanceName}.api.bemchat.com.br;
    location / {
        proxy_pass         http://localhost:${port};
        proxy_http_version 1.1;
        proxy_set_header   Upgrade $http_upgrade;
        proxy_set_header   Connection "upgrade";
        proxy_set_header   Host $host;
        proxy_cache_bypass $http_upgrade;
        proxy_set_header   X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header   X-Forwarded-Proto $scheme;
    }
}
`;
}
/**
 * Cria uma configuração Nginx na fila para ser processada pelo serviço externo
 * Cria dois arquivos:
 * 1. {instanceName}.conf - Arquivo de configuração
 * 2. {instanceName}.conf.ready - Arquivo sinalizador indicando que está pronto
 * @param instanceName - Nome da instância
 * @param port - Porta onde a instância está rodando
 */
async function createNginxConfig(instanceName, port) {
    const queuePath = process.env.NGINX_QUEUE_PATH || "/srv/bemchat/nginx-queue";
    try {
        // Gerar conteúdo da configuração
        const configContent = generateNginxConfigContent(instanceName, port);
        // Caminhos dos arquivos - usar instanceName, não o domínio
        const configFile = node_path_1.default.join(queuePath, `${instanceName}.conf`);
        const readyFile = node_path_1.default.join(queuePath, `${instanceName}.conf.ready`);
        // Criar arquivo de configuração
        await fileSystem.writeFile(configFile, configContent);
        console.log(`[nginxQueue] Created Nginx config: ${configFile}`);
        // Criar arquivo sinalizador
        await fileSystem.writeFile(readyFile, "");
        console.log(`[nginxQueue] Created ready signal: ${readyFile}`);
    }
    catch (error) {
        console.error(`[nginxQueue] Error creating Nginx config:`, error);
        throw new Error(`Failed to create Nginx config for ${instanceName}: ${error instanceof Error ? error.message : "Unknown error"}`);
    }
}
/**
 * Cria um arquivo de remoção na fila Nginx para sinalizar que a configuração deve ser removida
 * @param instanceName - Nome da instância
 */
async function removeNginxConfig(instanceName) {
    const queuePath = process.env.NGINX_QUEUE_PATH || "/srv/bemchat/nginx-queue";
    try {
        // Caminho do arquivo de remoção
        const removeFile = node_path_1.default.join(queuePath, `${instanceName}.conf.remove`);
        // Criar arquivo sinalizador de remoção
        await fileSystem.writeFile(removeFile, "");
        console.log(`[nginxQueue] Created removal signal: ${removeFile}`);
    }
    catch (error) {
        console.error(`[nginxQueue] Error creating removal signal:`, error);
        throw new Error(`Failed to create removal signal for ${instanceName}: ${error instanceof Error ? error.message : "Unknown error"}`);
    }
}
//# sourceMappingURL=nginxQueue.js.map