"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateConfigJson = void 0;
const node_crypto_1 = require("node:crypto");
const node_fs_1 = __importDefault(require("node:fs"));
const node_path_1 = __importDefault(require("node:path"));
const generateConfigJson = async (register, instancePath, instanceName, instanceType = "plataform") => {
    const configPath = instanceType === "api"
        ? node_path_1.default.join(instancePath, "app", "data")
        : node_path_1.default.join(instancePath, "backend", "data");
    const configFile = node_path_1.default.join(configPath, "config.json");
    // Criar diretório se não existir
    if (!node_fs_1.default.existsSync(configPath)) {
        node_fs_1.default.mkdirSync(configPath, { recursive: true });
    }
    // ========================
    // CONFIGURAÇÃO PARA API
    // ========================
    if (instanceType === "api") {
        const apiConfig = {
            register: {
                id: register.id,
                name: register.name,
                companyName: register.companyName,
                document: register.document,
                active: true,
                state: register.state,
                city: register.city,
            },
            api: {
                type: "Api",
                url: `https://${instanceName}.api.bemchat.com.br`,
                apiKey: (0, node_crypto_1.randomUUID)(),
                serverName: process.env.HOSTNAME || "unknown",
                serviceKey: (0, node_crypto_1.randomUUID)(),
                backendVersion: "1.1.26", // Versão atual das APIs
                frontendVersion: "-", // APIs não têm frontend
            },
            license: {
                active: true,
                startedAt: new Date().toISOString(),
                expiresAt: null, // Será configurado depois pelo Manager
                remainingDays: 0,
            },
            whatsapp: {
                phoneNumber: "",
                name: "",
                autoConnect: true,
            },
            smtp: {
                host: "smtpi.uni5.net",
                port: 465,
                secure: true,
                user: "nao-responda@bemchat.com.br",
                password: "BemSoft@123",
                from: '"BemChat API" <nao-responda@bemchat.com.br>',
            },
        };
        // Escrever arquivo config.json para API
        node_fs_1.default.writeFileSync(configFile, JSON.stringify(apiConfig, null, 2), "utf-8");
        console.log(`✅ [configGenerator] API config.json created at: ${configFile}`);
        console.log(`   - Register ID: ${register.id}`);
        console.log(`   - API URL: ${apiConfig.api.url}`);
        console.log(`   - Server: ${apiConfig.api.serverName}`);
        return configFile;
    }
    // ============================
    // CONFIGURAÇÃO PARA PLATAFORMA
    // ============================
    // biome-ignore lint/style/noUselessElse: <explanation>
    else {
        // Calcular data de expiração (7 dias a partir de hoje)
        const startedAt = new Date();
        const expiresAt = new Date();
        expiresAt.setDate(expiresAt.getDate() + 7);
        expiresAt.setHours(23, 59, 59, 0);
        // Calcular dias restantes
        const diffTime = expiresAt.getTime() - startedAt.getTime();
        const remainingDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
        const plataformConfig = {
            register: {
                id: register.id,
                name: register.name,
                companyName: register.companyName,
                document: register.document,
                active: true,
                state: register.state,
                city: register.city,
            },
            application: {
                url: `https://${instanceName}.bemchat.com.br`,
                apiKey: (0, node_crypto_1.randomUUID)(),
                type: "Plataforma",
                serverName: process.env.HOSTNAME || "unknown",
                serviceKey: (0, node_crypto_1.randomUUID)(),
                usedStorage: 0,
                backendVersion: "1.0.80",
                frontendVersion: "1.0.61",
            },
            license: {
                active: true,
                startedAt: startedAt.toISOString(),
                expiresAt: expiresAt.toISOString(),
                connectionLimit: 1,
                storageLimit: 20,
                userLimit: 7,
                remainingDays,
            },
            whatsapps: [],
        };
        // Escrever arquivo config.json para Plataforma
        node_fs_1.default.writeFileSync(configFile, JSON.stringify(plataformConfig, null, 2), "utf-8");
        console.log(`✅ [configGenerator] Plataforma config.json created at: ${configFile}`);
        console.log(`   - Register ID: ${register.id}`);
        console.log(`   - Application URL: ${plataformConfig.application.url}`);
        console.log(`   - Server: ${plataformConfig.application.serverName}`);
        console.log(`   - License expires: ${plataformConfig.license.expiresAt}`);
        return configFile;
    }
};
exports.generateConfigJson = generateConfigJson;
//# sourceMappingURL=configGenerator.js.map