"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initServer = void 0;
const routes_1 = require("./routes");
const node_server_1 = require("@hono/node-server");
require("dotenv/config");
const hono_1 = require("hono");
const logger_1 = require("hono/logger");
const logger_2 = require("./utils/logger");
const app = new hono_1.Hono();
app.use((0, logger_1.logger)(logger_2.customLogger));
app.route("/", routes_1.routes);
const initServer = async () => {
    const port = process.env.PORT ? Number(process.env.PORT) : 3000;
    return (0, node_server_1.serve)({ fetch: app.fetch, port }, (info) => {
        (0, logger_2.customLogger)(`server listening at ${info.port}`);
    });
};
exports.initServer = initServer;
//# sourceMappingURL=app.js.map