"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BemChatApi = void 0;
const cmdFunctions_1 = require("../../../utils/cmdFunctions");
const configGenerator_1 = require("../../../utils/configGenerator");
const dockerCompose = __importStar(require("../../../utils/dockerCompose"));
const dockerManager = __importStar(require("../../../utils/dockerManager"));
const fileSystem = __importStar(require("../../../utils/fileSystem"));
const instanceDatabase_1 = require("../../../utils/instanceDatabase");
const nginxQueue = __importStar(require("../../../utils/nginxQueue"));
const portManager = __importStar(require("../../../utils/portManager"));
const node_crypto_1 = require("node:crypto");
const node_fs_1 = __importDefault(require("node:fs"));
const node_os_1 = __importDefault(require("node:os"));
const node_path_1 = __importDefault(require("node:path"));
class BemChatApi {
    name;
    port;
    path;
    constructor(props) {
        this.name = props.name;
        this.port = props.port;
        this.path = props.path || "";
    }
    async createBemChat(register, customPort) {
        try {
            // 1. Obter próxima porta disponível
            const port = customPort || (await portManager.getNextAvailablePort());
            // 2. Definir caminhos
            const instancePath = node_path_1.default.join(process.env.API_INSTANCES_PATH || "/srv/bemchat/api", this.name);
            const appPath = node_path_1.default.join(instancePath, "app");
            const dataPath = node_path_1.default.join(appPath, "data");
            const baileysPath = node_path_1.default.join(appPath, "baileys");
            // 3. Verificar se instância já existe
            if (await fileSystem.fileExists(instancePath)) {
                return `Error: Instance ${this.name} already exists at ${instancePath}`;
            }
            // 4. Criar estrutura de diretórios
            console.log(`[BemChatApi] Creating directory structure for ${this.name}`);
            await fileSystem.createDirectory(dataPath, true);
            await fileSystem.createDirectory(baileysPath, true);
            // 5. Gerar config.json
            console.log(`[BemChatApi] Generating config.json for ${this.name}`);
            await (0, configGenerator_1.generateConfigJson)(register, instancePath, this.name, "api");
            // 6. Gerar docker-compose.yaml
            console.log(`[BemChatApi] Generating docker-compose.yaml for ${this.name}`);
            const dockerConfig = {
                instanceName: this.name,
                port,
                apiId: this.name,
                apiUrl: `https://${this.name}.api.bemchat.com.br`,
                serviceKey: (0, node_crypto_1.randomUUID)(),
                managerUrl: process.env.BEMCHAT_MANAGER_URL || "",
                managerKey: process.env.BEMCHAT_MANAGER_KEY || "",
                hostname: process.env.HOSTNAME || node_os_1.default.hostname(),
                appDataPath: dataPath,
                baileysPath: baileysPath,
            };
            const composeContent = dockerCompose.generateDockerCompose(dockerConfig);
            const composePath = node_path_1.default.join(instancePath, "docker-compose.yaml");
            await fileSystem.writeFile(composePath, composeContent);
            // 7. Pull da imagem Docker
            console.log(`[BemChatApi] Pulling Docker image for ${this.name}`);
            const dockerRegistry = process.env.DOCKER_REGISTRY || "docker.bemsoft.com.br";
            const dockerImage = process.env.DOCKER_IMAGE_API || "bemchat-api:latest";
            await dockerManager.pullImage(`${dockerRegistry}/${dockerImage}`);
            // 8. Iniciar container
            console.log(`[BemChatApi] Starting Docker container for ${this.name}`);
            await dockerManager.composeUp(composePath, this.name);
            // 9. Criar configuração Nginx na fila
            console.log(`[BemChatApi] Creating Nginx config for ${this.name}`);
            await nginxQueue.createNginxConfig(this.name, port);
            // 10. Registrar instância no banco de dados
            const db = (0, instanceDatabase_1.getDatabase)();
            db.addInstance({
                name: this.name,
                port,
                type: "api",
                path: instancePath,
            });
            return `API ${this.name} created successfully on port ${port}. Nginx configuration queued for processing.`;
        }
        catch (error) {
            if (error instanceof Error) {
                return `Error creating API ${this.name}: ${error.message}`;
            }
            return `Error creating API ${this.name}: Unknown error`;
        }
    }
    getBemChatInfo() {
        return { name: this.name, port: this.port, path: this.path };
    }
    async executeSpawn(cmd, interruption, cwd) {
        const result = await (0, cmdFunctions_1.spawnCmd)(cmd, interruption, { cwd });
        if (typeof result !== "string" ||
            (typeof result === "string" &&
                result.split("_")[1] !== "0" &&
                result.split("_")[1] !== "126")) {
            throw result;
        }
    }
    async verifyUpdateFiles() {
        const updateFrontendPath = node_path_1.default.join(this.path, "update-frontend.sh");
        const updateBackendPath = node_path_1.default.join(this.path, "update-backend.sh");
        try {
            if (!node_fs_1.default.existsSync(updateFrontendPath) ||
                !node_fs_1.default.existsSync(updateBackendPath)) {
                await this.executeSpawn("wget --content-disposition --quiet --show-progress https://update.bemchat.com.br/installers/api/update-api-files.zip", undefined, this.path);
                await this.executeSpawn(`unzip -P ${process.env.GENERAL_PASSWORD} update-api-files.zip`, {
                    message: "[y]es, [n]o, [A]ll, [N]one, [r]ename",
                    answer: "A",
                }, this.path);
                await this.executeSpawn("rm update-api-files.zip", undefined, this.path);
                if (!node_fs_1.default.existsSync(updateFrontendPath) ||
                    !node_fs_1.default.existsSync(updateBackendPath)) {
                    return "file update-frontend.sh OR update-backend.sh not found";
                }
                await this.executeSpawn(`chmod +x ${updateFrontendPath}`, undefined, this.path);
                await this.executeSpawn(`chmod +x ${updateBackendPath}`, undefined, this.path);
            }
        }
        catch (error) {
            console.log("error: ", error);
            return "file update-frontend.sh OR update-backend.sh not found";
        }
        return "";
    }
    async updateBemChat() {
        if (!node_fs_1.default.existsSync(this.path))
            return `folder ${this.path} not found`;
        const filesVerification = await this.verifyUpdateFiles();
        if (typeof filesVerification === "string" && filesVerification !== "") {
            return filesVerification;
        }
        const questionInterruption = {
            message: " will be removed and reinstalled from scratch. Proceed?",
            answer: "Y",
        };
        const statusCodeFrontend = await (0, cmdFunctions_1.spawnCmd)("./update-frontend.sh", questionInterruption, { cwd: this.path });
        const statusCodeBackend = await (0, cmdFunctions_1.spawnCmd)("./update-backend.sh", questionInterruption, { cwd: this.path });
        if (typeof statusCodeFrontend === "string" &&
            typeof statusCodeBackend === "string") {
            const returnCodeFrontend = statusCodeFrontend.split("_")[1];
            const returnCodeBackend = statusCodeBackend.split("_")[1];
            if (returnCodeFrontend !== "0" || returnCodeBackend !== "0") {
                return `Error updating Bemchat ${this.name} ${returnCodeFrontend !== "0" ? "Frontend" : "Backend"}`;
            }
            return `BemChat ${this.name} updated`;
        }
        return "Error while updating bemchat";
    }
    async deleteBemChat() {
        try {
            const instancePath = node_path_1.default.join(process.env.API_INSTANCES_PATH || "/srv/bemchat/api", this.name);
            const composePath = node_path_1.default.join(instancePath, "docker-compose.yaml");
            // 1. Verificar se instância existe
            if (!(await fileSystem.fileExists(instancePath))) {
                return `Error: Instance ${this.name} does not exist at ${instancePath}`;
            }
            // 2. Parar e remover container Docker
            console.log(`[BemChatApi] Stopping Docker container for ${this.name}`);
            if (await fileSystem.fileExists(composePath)) {
                await dockerManager.composeDown(composePath, this.name);
            }
            // 3. Remover diretório da instância
            console.log(`[BemChatApi] Removing directory for ${this.name}`);
            await fileSystem.deleteDirectory(instancePath, true);
            // 4. Criar arquivo de remoção na fila Nginx
            console.log(`[BemChatApi] Queueing Nginx config removal for ${this.name}`);
            await nginxQueue.removeNginxConfig(this.name);
            // 5. Remover instância do banco de dados
            const db = (0, instanceDatabase_1.getDatabase)();
            db.removeInstance(this.name);
            return `API ${this.name} deleted successfully. Nginx configuration removal queued for processing.`;
        }
        catch (error) {
            if (error instanceof Error) {
                return `Error deleting API ${this.name}: ${error.message}`;
            }
            return `Error deleting API ${this.name}: Unknown error`;
        }
    }
    async restart() {
        try {
            const instancePath = node_path_1.default.join(process.env.API_INSTANCES_PATH || "/srv/bemchat/api", this.name);
            const composePath = node_path_1.default.join(instancePath, "docker-compose.yaml");
            if (!(await fileSystem.fileExists(composePath))) {
                return `Error: API instance ${this.name} not found at ${instancePath}`;
            }
            console.log(`[BemChatApi] Restarting Docker container for ${this.name}`);
            await dockerManager.composeRestart(composePath, this.name);
            return `API ${this.name} restarted successfully`;
        }
        catch (error) {
            if (error instanceof Error) {
                return `Error restarting API ${this.name}: ${error.message}`;
            }
            return `Error restarting API ${this.name}: Unknown error`;
        }
    }
}
exports.BemChatApi = BemChatApi;
//# sourceMappingURL=bemchat-api.js.map