"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bemchatManager = void 0;
const storageInfo_1 = require("../../../utils/storageInfo");
const node_os_1 = __importDefault(require("node:os"));
const bytesToGb = 1073741824; //(1024 * 1024 * 1024)
class BemchatManager {
    urlApi;
    keyApi;
    apiServiceKey;
    constructor() {
        this.urlApi = process.env.BEMCHAT_MANAGER_URL || "";
        this.keyApi = process.env.BEMCHAT_MANAGER_KEY || "";
        this.apiServiceKey = process.env.API_SERVICE_KEY || "";
        console.log("Starting BemchatManager Connector: ", this.urlApi || "No URL defined");
    }
    async getInfo() {
        const storage = await (0, storageInfo_1.storageInfo)();
        return {
            name: node_os_1.default.hostname(),
            storage: storage[0] || "0.00",
            usedStorage: storage[1] || "0.00",
            cpu: node_os_1.default.cpus().length,
            ramMemory: `${Math.ceil(node_os_1.default.totalmem() / bytesToGb)} Gb`,
            apiKey: this.apiServiceKey,
        };
    }
    async updateInfo() {
        if (!this.urlApi) {
            console.log("BemchatManager :: Cannot send info: urlApi not defined");
            return;
        }
        if (!this.keyApi) {
            console.log("BemchatManager :: Cannot send info: keyApi not defined");
            return;
        }
        const info = await this.getInfo();
        console.log("BemchatManager :: Sending info");
        fetch(`${this.urlApi}/webhooks/server/data`, {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                Authorization: `Bearer ${this.keyApi}`,
            },
            body: JSON.stringify(info),
        })
            .then(async (response) => {
            if (response.status === 200) {
                console.log("BemchatManager :: Info sent");
            }
            else {
                try {
                    const responseBody = await response.json();
                    console.log("BemchatManager :: Error sending info", JSON.stringify({
                        status: response.status,
                        statusText: response.statusText,
                        response: responseBody,
                    }, null, 2));
                }
                catch (error) {
                    console.log("BemchatManager :: Error sending info", error);
                }
            }
        })
            .catch((error) => {
            console.error("BemchatManager :: Error: ", error);
        });
    }
}
exports.bemchatManager = new BemchatManager();
