"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.spawnCmd = exports.execCommand = void 0;
const node_child_process_1 = require("node:child_process");
const logger_1 = require("./logger");
const execCommand = async (command, sendOutput = true) => {
    return new Promise((resolve, reject) => {
        (0, node_child_process_1.exec)(command, (error, stdout, stderr) => {
            try {
                // Verificar apenas se houve erro real (código de saída diferente de 0)
                // stderr pode conter mensagens informativas (como no docker compose)
                if (error) {
                    logger_1.logger.error(error?.message || stderr);
                    throw new Error(error?.message || stderr);
                }
                // Se não houve erro, retornar stdout (stderr pode ter mensagens informativas)
                resolve(sendOutput ? stdout : null);
            }
            catch (error) {
                reject(sendOutput ? error : null);
            }
        });
    });
};
exports.execCommand = execCommand;
const spawnCmd = async (command, interruption, options) => {
    return new Promise((resolve, reject) => {
        const processInstance = (0, node_child_process_1.spawn)(command, {
            shell: true,
            stdio: "pipe",
            ...options,
        });
        const verifyInterruption = (output) => {
            if (!interruption || !processInstance.stdin)
                return;
            const interruptions = Array.isArray(interruption)
                ? interruption
                : [interruption];
            for (const int of interruptions) {
                if (output.includes(int.message)) {
                    processInstance.stdin.write(`${int.answer}\n`);
                    break; // Para após primeira correspondência
                }
            }
        };
        if (processInstance.stdout) {
            processInstance.stdout.on("data", (data) => {
                const output = data.toString();
                console.log(`${output}`);
                verifyInterruption(output);
            });
        }
        if (processInstance.stderr) {
            processInstance.stderr.on("data", (data) => {
                const output = data.toString();
                console.log(`error: ${output}`);
                verifyInterruption(output);
            });
        }
        processInstance.on("close", (code) => {
            resolve(`CODE_${code}`);
        });
    });
};
exports.spawnCmd = spawnCmd;
