"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseRequestBody = void 0;
const parseRequestBody = async (c) => {
    const contentType = c.req.header("content-type") || "";
    if (contentType.includes("application/json")) {
        return await c.req.json();
    }
    if (contentType.includes("multipart/form-data") ||
        contentType.includes("application/x-www-form-urlencoded")) {
        const formData = await c.req.formData();
        const data = {};
        for (const [key, value] of formData.entries()) {
            data[key] = value;
        }
        return data;
    }
    return {};
};
exports.parseRequestBody = parseRequestBody;
