"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNextAvailablePort = getNextAvailablePort;
exports.isPortInUse = isPortInUse;
exports.saveLastPort = saveLastPort;
const instanceDatabase_1 = require("./instanceDatabase");
/**
 * Obtém a próxima porta disponível para uma nova instância API
 * Busca a primeira porta livre a partir de API_PORT_START (padrão: 2000)
 * @returns Próxima porta disponível
 */
async function getNextAvailablePort() {
    const startPort = Number.parseInt(process.env.API_PORT_START || "2000", 10);
    const db = (0, instanceDatabase_1.getDatabase)();
    try {
        const port = db.getNextAvailablePort(startPort);
        console.log(`[portManager] Next available port: ${port}`);
        return port;
    }
    catch (error) {
        console.error(`[portManager] Error getting next available port:`, error);
        throw new Error(`Failed to get next available port: ${error instanceof Error ? error.message : "Unknown error"}`);
    }
}
/**
 * Verifica se uma porta está em uso
 * @param port - Porta a verificar
 * @returns true se a porta está em uso, false caso contrário
 */
async function isPortInUse(port) {
    const db = (0, instanceDatabase_1.getDatabase)();
    try {
        return db.isPortInUse(port);
    }
    catch (error) {
        console.error(`[portManager] Error checking if port is in use:`, error);
        return false;
    }
}
/**
 * Registra uma porta como utilizada (não mais necessário com SQLite)
 * Mantido para compatibilidade, mas não faz nada
 * @deprecated Use instanceDatabase.addInstance() diretamente
 */
async function saveLastPort(port) {
    // Não faz nada - a porta é registrada quando a instância é adicionada ao banco
    console.log(`[portManager] saveLastPort is deprecated - port ${port} will be registered with instance`);
}
