"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.storageInfo = void 0;
const node_child_process_1 = require("node:child_process");
const logger_1 = require("./logger");
const storageInfo = async () => {
    return await Promise.all([
        new Promise((resolve, reject) => {
            (0, node_child_process_1.exec)("df --output=size --block-size=1M / | tail -n 1", (error, stdout, stderr) => {
                try {
                    if (error || stderr) {
                        logger_1.logger.error(error?.message || stderr);
                        throw new Error(error?.message || stderr);
                    }
                    resolve((Number(stdout?.trim() || "-1") / 1024).toFixed(2));
                }
                catch (error) {
                    resolve("0.00");
                }
            });
        }),
        new Promise((resolve, reject) => {
            (0, node_child_process_1.exec)("df --output=used --block-size=1M / | tail -n 1", (error, stdout, stderr) => {
                try {
                    if (error || stderr) {
                        logger_1.logger.error(error?.message || stderr);
                        throw new Error(error?.message || stderr);
                    }
                    resolve((Number(stdout?.trim() || "-1") / 1024).toFixed(2));
                }
                catch (error) {
                    resolve("0.00");
                }
            });
        }),
    ]);
};
exports.storageInfo = storageInfo;
