"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAuthApi = void 0;
const factory_1 = require("hono/factory");
const isAuthApi = (0, factory_1.createMiddleware)(async (c, next) => {
    const authorizationHeader = c.req.header("authorization");
    if (!authorizationHeader) {
        c.status(401);
        return c.json({ message: "Unauthorized" });
    }
    const token = authorizationHeader.split(" ")[1];
    if (!token || token !== process.env.API_SERVICE_KEY) {
        c.status(401);
        return c.json({ message: "Unauthorized" });
    }
    await next();
});
exports.isAuthApi = isAuthApi;
