"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateDockerCompose = generateDockerCompose;
/**
 * Gera o conteúdo de um arquivo docker-compose.yaml para uma instância API
 * @param config - Configuração da instância
 * @returns Conteúdo do arquivo docker-compose.yaml
 */
function generateDockerCompose(config) {
    const dockerRegistry = process.env.DOCKER_REGISTRY || "docker.bemsoft.com.br";
    const dockerImage = process.env.DOCKER_IMAGE_API || "bemchat-api:latest";
    return `services:
  api:
    container_name: ${config.instanceName}
    image: ${dockerRegistry}/${dockerImage}
    ports:
      - "${config.port}:3000"
    volumes:
      - "${config.baileysPath}:/app/baileys"
      - "${config.appDataPath}:/app/data"
    environment:
      SERVER_PORT: 3000
      API_ID: "${config.apiId}"
      API_URL: "${config.apiUrl}"
      API_SERVICE_KEY: "${config.serviceKey}"
      BEMCHAT_MANAGER_URL: "${config.managerUrl}"
      BEMCHAT_MANAGER_KEY: "${config.managerKey}"
      HOST_NAME: "${config.hostname}"
    restart: unless-stopped
`;
}
